' /////////////////////////////////////////////////////////////////////////////
' Atari Joystick driver
' AUTHOR: Jeff Ledger
' LAST MODIFIED: 4.19.07
' VERSION 1.0
' COMMENTS:


' ///////////////////////////////////////////////////////////////////////////


CON
 {No variables requires}

VAR

  long  cogon, cog
  long  junk       'Left to maintain compatibility
  long  compat     'Left to maintain compatibility 

PUB start : okay

'' Start the NES gamepad reading process
'' returns false if no cog available
''
  stop
  okay := cogon := (cog := cognew(@junk,@compat)) > 0


PUB stop

'' Stops driver - frees a cog

  if cogon~
    cogstop(cog)

PUB read : joy_bits

'This is designed for the adapter: 'atari_vga_schematic.jpg"

  ' JOYSTICK bit encodings -- Provided as reference
' JOY_RIGHT   = %00000001
' JOY_LEFT    = %00000010
' JOY_DOWN    = %00000100
' JOY_UP      = %00001000
' JOY_FIRE    = %00010000

  joy_bits := 0
  
  DirA[16]  := 0 'Set to read FIRE BUTTON
  DirA[17]  := 0 'Set to read RIGHT
  DirA[18]  := 0 'part of VGA DAC, set as In for safety  
  DirA[19]  := 0 'part of VGA DAC, set as In for safety  
  DirA[19]  := 0 'Set to read LEFT
  DirA[20]  := 0 'part of VGA DAC, set as In for safety  
  DirA[21]  := 0 'Set to read DOWN
  DirA[22]  := 0 'part of VGA DAC, set as In for safety
  DirA[23]  := 0 'Set to read UP


   if ina[16] == 1 'READ JOY_FIRE
      joy_bits := %00010000

  if ina[17] == 1 'READ JOY_RIGHT
     joy_bits := %00000001

  if ina[19] == 1 'READ JOY_LEFT
     joy_bits := %00000010

  if ina[21] == 1 'READ JOY_DOWN
     joy_bits := %00000100

  if ina[23] == 1 'READ JOY_UP
     joy_bits := %00001000



PUB button(WhichOne)
{{ Return value:     true or false                                          }}
  if WhichOne == read
    return true
  else
    return false
